// declare public variable
var qagentBootstrap;

// initilize QuestAgent bootstrap object...
(function() {

	qagentBootstrap = {}
	qagentBootstrap.state = {};
	
	qagentBootstrap.showInitOverlay = false;
	
	qagentBootstrap.initLoader = function(loader) {
		//alert("In initLoader()");
		// instruct loader to load up to "questagent" module only
		return "questagent";
	}
	
	qagentBootstrap.loadedYUIModule = function(info) { 
		//alert('Loaded module: ' + info.name); 
	}

	qagentBootstrap.loadedAllModules = function() {
		//alert('Loaded all modules'); 
		qagentBootstrap.state.loadedModules = true;
	}
	
	qagentBootstrap.onJavaNotFound = function() {
		alert('Search engine initialization script can not detect Java in your browser.\n' +
			'QuestAgent search applet requires Java 1.4.x or higher installed.\n' +
			'It is possible that Java is not installed on your system or has been disabled.\n\n' +
			'Will try to init search applet anyway...' );
		// return false if you don't want to proceed with applet initialization
		return true;
	}

	var startedInit = false;
	var initCallback;
	
	/**
		This function will be invoked by JavaScript to initialize search engine
	*/
	qagentBootstrap.initializeSearchEngine = function(cb) {
	
		if( qagentBootstrap.state.engineInitialized || startedInit ) {
			return;
		}
		startedInit = true;
		initCallback = cb;



		var qagentConfig = new questagent.QAConfigDefaults();
		qagentConfig.msgInitializingSearchEngine = "Initializing QuestAgent search engine.<br/>This may take several seconds.";
		
		MyModel.prototype = new questagent.HtmlJSBasedModel; // Define sub-class
		MyModel.prototype.constructor = MyModel;
		function MyModel()
		{
		    //questagent.HtmlJSBasedModel.call(this,searchApplet);  // Call super-class constructor (if desired)
		}
		
		MyModel.prototype.onSearchAppletInitialized = function(args) {

			questagent.util.log.info('Search applet has been initialized. Call super class handler...');
			questagent.HtmlJSBasedModel.prototype.onSearchAppletInitialized.call(this, args);

			qagentBootstrap.state.engineInitialized = true;
		
			questagent.util.log.debug('Invoke callback if available: ' + initCallback);
			if(initCallback)
				initCallback();
				
			questagent.util.log.debug('Done with customized onSearchAppletInitialized');
		};
	
		//var qaModel = new questagent.HtmlJSBasedModel();
		var qaModel = new MyModel();
		
		window.qagentConfig = qagentConfig;
		window.qaModel = qaModel;
		
		// show wait panel while search engine is being initialized
		var f = questagent.util.findLargestFrameDeep(top);
		if( f && f.frame ) {
			questagent.util.showPleaseWaitPanel( 
				qagentConfig.msgInitializingSearchEngine, f.frame, qagentConfig );
		}
		
		// start engine initialization
		qaModel.init(window.qagentConfig);
	}
	
})();

