
var qaAutoConfig;

(function() {

	if(!window.qaAutoConfig)
		qaAutoConfig = {};

	// determine qagent scripts base...
	var qaHomePath = "";
	var foundQaHomePath = false;

	var scripts = document.getElementsByTagName("script"); // @feature
	if(scripts) {

		for (var i = 0; i < scripts.length; i++) {
			var src = "" + scripts[i].getAttribute("src");
			debug("Found reference to script " + src);
			var ind = src.indexOf("autoconfig.js"); // @feature
			if( ind != -1 ) {
				qaHomePath = src.substring(0,ind);
				qaAutoConfig.qaHomePath = qaHomePath;
				foundQaHomePath = true;
				break;
			}
		}
		if( foundQaHomePath )
			debug("Auto-determined QuestAgent home is '" + qaHomePath + "'");
		else
			debug("Not found QA script inclusion by name. Possibly renamed folder/file." );
	}
	else {
		debug("Did not find script references in page " + window.location );
	}

	var logEnabled = false;
	if( isScriptDebugEnabled() )
		logEnabled = true;

	// check environment and load prerequisities
	if(!qaAutoConfig.layout) {
		if( window.parent && window.parent != window ) {
			qaAutoConfig.layout = 'framed';
		}
		else {
			qaAutoConfig.layout = 'popup';

			// import style used for predefined search form in popup layer
			importStyle('jsutil/yui2/container/assets/skins/sam/container.css',document);

			// TODO report error if js was loaded in frameset file?
		}
	}


	function debug( msg )
	{
		//alert( msg );
	}

	function injectScript(src, id, code, doc, el)
	{
		if( !doc )
			doc = document;

		var script = doc.createElement('script');
		script.type = 'text/javascript';

		if( src )
			script.src = (qaAutoConfig.qaHomeURL || qaHomePath) + src;

		if( id )
			script.id = id;

		if( code ) {
			// IE doesn't let script elements have children.
			if (null != script.canHaveChildren) script.text = code;
			// But most other browsers do.
			else script.appendChild(doc.createTextNode(code));
		}

		el = el || doc.getElementsByTagName('head')[0];

		if( window.questagent && window.questagent.util && window.questagent.util.log )
			window.questagent.util.log.debug( 'Importing script: ' + script.src );

		el.appendChild(script);
	}
	qaAutoConfig.injectScript = injectScript;


	function importStyle(src, doc)
	{
		// FIXME make sure that style is not already defined?  or is it handled by test of YAHOO presence on form injection

		var headID = doc.getElementsByTagName("head")[0];
		var cssNode = doc.createElement('link');
		cssNode.type = 'text/css';
		cssNode.rel = 'stylesheet';
		cssNode.href = (qaAutoConfig.qaHomeURL || qaHomePath) + src;
		cssNode.media = 'screen';

		if( window.questagent && window.questagent.util && window.questagent.util.log )
			window.questagent.util.log.debug( 'Importing style: ' + cssNode.href );

		headID.appendChild(cssNode);
	}
	qaAutoConfig.importStyle = importStyle;


	function isScriptDebugEnabled()
	{
		var win = window;
		while( true ) {
			if( win.location.search ) {
				var winParams = extractParams(win.location.search);
				if( winParams['debug'] ) {
					if( winParams['debug'] == 'false' )
						return false;
					else
						return true;
				}
			}
			if( win.parent == win )
				break;
			win = win.parent;
		}
		return ( "DEBUG" == getCookie( "QAJSLog" ) );
	}

	function getCookie( name ) {
		var start = document.cookie.indexOf( name + "=" );
		var len = start + name.length + 1;
		if ( ( !start ) && ( name != document.cookie.substring( 0, name.length ) ) ) {
			return null;
		}
		if ( start == -1 ) return null;
		var end = document.cookie.indexOf( ";", len );
		if ( end == -1 ) end = document.cookie.length;
		return unescape( document.cookie.substring( len, end ) );
	}

	/** Copy of the same function in questagent.util **/
	function extractParams( p )
	{
		if( p.charAt( 0 ) == '?' )  {
			p = p.substring( 1, p.length );
		}

		var paramsObject = new Object();

		var params = p.split( '&' );
		for( i = 0; i < params.length; i++ )
		{
			var ind = params[i].indexOf( "=" );
			if( ind != -1 )
			{
				var name = params[i].substring( 0, ind );
				var val = unescape( params[i].substring( ind + 1 ) );

				if( val == "true" || val == "false" || !isNaN( parseFloat( val ) ) ) {
					paramsObject[name] = eval(val);
				}
				else {
					paramsObject[name] = val;
				}
			}
		}
		return paramsObject;
	}

	// load YUI loader that will handle loading ordering depending on dependencies defined above
	injectScript('jsutil/yui2/yuiloader/yuiloader-min.js');

	qaAutoConfig.YAHOO_config = {
		require: ['yuiloader-dom-event', 'container'],
		base: ((qaAutoConfig.qaHomeURL || qaHomePath) + 'jsutil/yui2/'),
		loadOptional: false,

		onFailure: function(msg, xhrobj) { 
			var m = "LOAD FAILED: " + msg; 
			alert(m);
		},

		onSuccess: function(o) {
			//debug("Loaded all QuestAgent dependencies!");
			if( window.qagentBootstrap && window.qagentBootstrap.loadedAllModules ) {
				window.qagentBootstrap.loadedAllModules();
			}
		}
	};

	window.yahooLoaderFn = function() {
		if(window.YAHOO && window.YAHOO.util && window.YAHOO.util.YUILoader) {
			var loader = new YAHOO.util.YUILoader( qaAutoConfig.YAHOO_config );
			qaAutoConfig.loader = loader;
			
			// define modules
			qaAutoConfig.loader.addModule({
				name: 'log4javascript',
				type: 'js',
				fullpath: ((qaAutoConfig.qaHomeURL || qaHomePath) +
					(logEnabled ? 'jsutil/log4javascript.js' : 'jsutil/log4javascript_stub.js')),
				//verifier: checkLog4JS
				varName: "log4javascript.getDefaultLogger"
			});

			qaAutoConfig.loader.addModule({
				name: 'qautil',
				type: 'js',
				fullpath: ((qaAutoConfig.qaHomeURL || qaHomePath) + 'qautil.js'),
				//verifier: checkQAUtil,
				varName: "questagent.util.log",
				requires: ['log4javascript']
			});

			qaAutoConfig.loader.addModule({
				name: 'questagent',
				type: 'js',
				fullpath: ((qaAutoConfig.qaHomeURL || qaHomePath) + 'questagent.js'),
				//verifier: checkQuestAgent,
				varName: "questagent.initSearchApplet",
				requires: ['qautil', 'container']
			});

			qaAutoConfig.loader.addModule({
				name: 'autoinit',
				type: 'js',
				fullpath: ((qaAutoConfig.qaHomeURL || qaHomePath) + 'autoinit.js'),
				//verifier: checkQAAutoInit,
				varName: "startSearch",
				requires: ['questagent']
			});
			
			var requiredModule = 'autoinit';

			// if bootstrap exists, allow it to amend the loading procedure
			if( window.qagentBootstrap && window.qagentBootstrap.initLoader ) {
				// bootstrap's initLoader receives references to loader and path to qagent folder that can use in module definition
				requiredModule = window.qagentBootstrap.initLoader(qaAutoConfig.loader, (qaAutoConfig.qaHomeURL || qaHomePath));
			}

			if(requiredModule)
				qaAutoConfig.loader.require(requiredModule);
			
			loader.insert();
		}
		else {
			setTimeout("window.yahooLoaderFn()", 50);
		}
	}
	setTimeout("window.yahooLoaderFn()", 50);	

})();

