
(function() {

	/*function isdefined( variable)
	{
		return (typeof(window[variable]) == "undefined")?  false: true;
	}*/

	if( !window.questagent || !questagent.util ||
		!window.qaAutoConfig || !window.qaAutoConfig.layout ||
		!window.document.getElementById || !window.YAHOO ) 
	{
		//alert('QuestAgent prerequisities are not available. Loaded autoinit.js instead of autoconfig.js?');
		return;
	}
	
	YAHOO.namespace("jobjects.questagent");

	// shortcuts for YUI components
	var Overlay = YAHOO.widget.Overlay;
	var Event = YAHOO.util.Event;
	var Dom = YAHOO.util.Dom;
	
	
	var searchFormId = 'qasearchform';
	
	var log = questagent.util.log;
	log.info('In autoinit.js' );

	// We always start from the default config...
	var qagentConfig = new questagent.QAConfigDefaults();
	qagentConfig.qaHomePath = qaAutoConfig.qaHomePath;
	
	// add expected names of search form and its elements
	qagentConfig.searchFormId = 'qaSearchForm';
	qagentConfig.queryTextFieldId = 'qaQuery';
	qagentConfig.collectionSelectId = 'qaColls';
	qagentConfig.searchButtonId = 'qaSearchButton';
	
	if(qaAutoConfig.targetElement)
		qagentConfig.targetElement = qaAutoConfig.targetElement;
	
	function showAlternateFormLink()
	{
		if( YAHOO.jobjects.questagent.initializingMessage )
			YAHOO.jobjects.questagent.initializingMessage.hide();
			
		log.debug( "qagentConfig.onLoad" );
		if( document.getElementById(qagentConfig.searchFormId) ) {
			log.debug( "Found user provided search form." );
			return;
		}
		
		var altSearchFormLink = new Overlay("altSearchFormLink", 
			{ 
				width:"32px",
				context:[document.body,"tr","tr"],
				visible:true // FIXME (YUI 2.3.0 bug?) If set to false, click event not coulght in IE (but works if Module us used istead of Overlay)
			} ); 
			
		altSearchFormLink.setBody(
			'<img src="' + qaAutoConfig.qaHomePath + 'find32s.gif" ' +
			' title="' + qagentConfig.msgFormLinkTitle + '" ' +
			' style="cursor: pointer;" border="0" />' );
			
		Event.addListener( altSearchFormLink.id, "click", function() 
		{
			toggleSearchForm();
		}, this, false );

		altSearchFormLink.updatePosition = function()
		{
			log.debug('Updating altSearchFormLink position.');
			var padx = 5, pady = 5;
			var scrollX = Dom.getDocumentScrollLeft(),
				scrollY = Dom.getDocumentScrollTop(),
				viewPortWidth = Dom.getClientWidth(),
				viewPortHeight = Dom.getClientHeight(),
				elementWidth = this.element.offsetWidth,
				elementHeight = this.element.offsetHeight,
				x = scrollX + viewPortWidth - elementWidth - padx,
				y = scrollY + pady;
			//questagent.util.log.error( [scrollX, scrollY, viewPortWidth, viewPortHeight, elementWidth, elementHeight] );
			//questagent.util.log.error( [x, y] );
			
			// FIXME use queueProperty ?
			this.cfg.setProperty("xy", [x, y]);
			this.cfg.refireEvent("iframe");
		};
		
		Overlay.windowScrollEvent.subscribe( altSearchFormLink.updatePosition, altSearchFormLink, true);

		altSearchFormLink.beforeShowEvent.subscribe( function()
		{
			//log.debug( "altSearchFormLink.beforeShowEvent" );
			this.updatePosition();
		}, altSearchFormLink, true );
		
		altSearchFormLink.render(document.body);
		altSearchFormLink.hide(); // FIXME - to workarounf visible:false problem mentioned above
		altSearchFormLink.show();
	};
	
	// =======================================================
	// Define AutoHtmlJSBasedModel extending HtmlJSBasedModel
	// =======================================================
	
	var AutoHtmlJSBasedModel = function() {
	};
	questagent.util.extendClass( AutoHtmlJSBasedModel, questagent.HtmlJSBasedModel );
	
	AutoHtmlJSBasedModel.prototype.onSearchAppletInitialized = function(args) {

		questagent.util.log.info('Search applet has been initialized. Call super class handler...');
		questagent.HtmlJSBasedModel.prototype.onSearchAppletInitialized.call(this, args);

		showAlternateFormLink();
		
		questagent.util.log.info('Determine target frame.');
		var target = this.getDocumentTargetFrameRef();
		if( target ) {
			qaAutoConfig.formHolderFrameName = window.name;
			questagent.util.log.debug('By default, search form is expected in window: ' + 
				qaAutoConfig.formHolderFrameName);
		}
		questagent.util.log.debug('Done with onSearchAppletInitialized');
	};
		
	/*AutoHtmlJSBasedModel.prototype.setAppletWrapper = function(wrapper) {
		questagent.HtmlJSBasedModel.prototype.setAppletWrapper.call(this, wrapper);

		wrapper.eventInitializingApplet.subscribe( function() {
			// TODO
		}, this );
	}*/
	
	/*AutoHtmlJSBasedModel.prototype.onSearchEngineInitStarts = function() {
		questagent.HtmlJSBasedModel.prototype.onSearchEngineInitStarts.call(this);
		questagent.util.showEngineInitOverlay(window, qagentConfig);
	}*/
/*	AutoHtmlJSBasedModel.prototype.onSearchAppletInitialized = function(args) {
		log.debug("HtmlJSBasedModel.onSearchAppletInitialized");
		
		
		questagent.HtmlJSBasedModel.prototype.onSearchAppletInitialized.call(this, args);
	}*/

	// ================================
	// Initialize search interface model
	// ================================
	var model;
	if( qaAutoConfig.layout == 'framed' ) {
		log.info('Using AutoHtmlJSBasedModel model');
		model = new AutoHtmlJSBasedModel();
	}
	else if( qaAutoConfig.layout == 'popup' ) {
		log.info('Using PopupSearchWindowModel model');
		qagentConfig.onLoad = showAlternateFormLink;
		model = new questagent.PopupSearchWindowModel();
	}
	else if( qaAutoConfig.layout == 'inpage' ) {
		log.info('Using AutoHtmlJSBasedModel model');
		model = new questagent.DHtmlJSBasedModel();
	}
	else {
		log.fatal('Unknown qaAutoConfig.layout: ' + qaAutoConfig.layout);
		return;
	}

	if( model )
	{
		window.qagentConfig = qagentConfig;
		window.qaModel = model;
		
		log.debug('Initializing model');		
		model.init( qagentConfig );
	}
	
	function toggleSearchForm()
	{
		var target = (typeof model.getDocumentTargetFrameRef == 'function') ? 
			model.getDocumentTargetFrameRef() : window;
			
		//if( qaAutoConfig.layout == 'framed' ) {
			//target = model.getDocumentTargetFrameRef();
			if( target ) {
				qaAutoConfig.formHolderFrameName = target.name;
				if( target.altSearchForm && target.document.getElementById('altSearchForm') ) {
					log.debug('Search form already exists in target document.');
					
					if( target.altSearchForm.cfg.getProperty('visible') )
						target.altSearchForm.hide();
					else {
						target.altSearchForm.show();
						
						var query = target.document.getElementById('qaQuery');
						if( query )
							query.focus();
					}
				}
				else {
					log.debug('Adding search form div to target document: ' + target.name);

					if( !target.questagent )
						target.questagent = {};
					
					if( !target.questagent.util )
						target.questagent.util = questagent.util;
					
					if( !target.startSearch )
						target.startSearch = startSearch;
					
					target.qaAltInit = qagentConfig;

					questagent.util.addYUI( target, qagentConfig, 
						function( yuiLoaded ) { 
							qaAutoConfig.injectScript( 'altsearchform.js',null,null,target.document);
						}
					);
					log.debug('Injected scripts');
				}
			}
			else {
				log.error('Couldn\'t find target window to show form.');
				return;
			}
		/*}
		else if( qaAutoConfig.layout == 'popup' ) {
			target = window;
		}*/
		return false;
	}
	qaAutoConfig.toggleSearchForm = toggleSearchForm;
})();


/**
Returns object containing search parameters.
*/
function getSearchParams()
{
	questagent.util.log.debug('Collecting search params from form in window: ' + qaAutoConfig.formHolderFrameName);

	var formWindow = window;
	if(qaAutoConfig.layout == 'framed') {
		/* Important: 
		If qaAutoConfig.formHolderFrameName equals to window.name, expression
			formWindow = window.parent.frames[qaAutoConfig.formHolderFrameName];
		in IE 6.0 returns parent it self instead reference to frame window. 
		That's why we test someting that should obviously work (and works in normal browsers as FF.)
		*/
		if( qaAutoConfig.formHolderFrameName == window.name )
			formWindow = window;
		else
			formWindow = window.parent.frames[qaAutoConfig.formHolderFrameName];
	}
	
	var params = {};
	try {
		//questagent.util.log.debug(formWindow.location);
		questagent.util.log.debug('Lookup query field ' + qagentConfig.queryTextFieldId + " in " + formWindow.name + ' ' + formWindow.location);
		
		// get query string
		params.query = formWindow.document.getElementById(qagentConfig.queryTextFieldId).value;
		
		// get selected collections
		params.colls = [];
		var collEl = document.getElementById(qagentConfig.collectionSelectId);
		for( i = 0; collEl && i < collEl.length; ++i ) {
			if( collEl.options[i].selected ) {
				params.colls.push( collEl.options[i].value );
			}
		}
		
	}
	catch(e) {
		questagent.util.log.error('Failed to get query field.');
		questagent.util.log.error( e );
	}
		
	questagent.util.log.debug("Collected search params");
	questagent.util.log.debug(params);
	
	return params;
}

function startSearch()
{
	questagent.util.log.debug("Search submit!");
	
	var searchParams = getSearchParams();
	if( !searchParams ) {
		questagent.util.log.error("Search request is not valid. Quiting.");
		return;
	}
	
	if( !searchParams.query || searchParams.query.length == 0 ) {
		questagent.util.log.debug("Query is not specified.");
		// FIXME show alert?
		return;
	}

	// start search
	try	{
		var model = questagent.util.getSearchInterfaceModel();
		/*
		var target = (model && typeof model.getDocumentTargetFrameRef == 'function') ? 
			model.getDocumentTargetFrameRef() : window;
		
		var config = window.qaAltInit || window.qagentConfig;
		questagent.util.showPleaseWaitPanel( config.msgSearchInProgress, target, config );
*/
		if( model )
			model.search(searchParams);
		else
			questagent.util.log.fatal('Can not find model to run search.');

		questagent.util.log.debug('Invoked search.');
	}
	catch( e ) {
		questagent.util.log.error(e);
	}
	return false;
}
