// callbacks.js

// This file contains JavaScript functions triggered by QuestAgent search applet.
// Their names are also listed in applet's params so if you need to change some function name
// make sure to rename it in the appropriate param too.

var docLoaded = false;
var appletStarted = false;

function OnAppletDocLoaded()
{
	docLoaded = true;
	
	questagent.util.log.debug("Applet hosting frame loaded: " + window.name );
}

var qaStartupDelay = 0;

function OnAppletStart()
{
try {
	questagent.util.log.debug("Applet started in window: " + window.name );

	var appletEl = document.getElementById("QuestAgent");
	
	// make sure we have the appropriate object printing some info about and from applet
	//questagent.util.log.debug("Applet element: " + appletEl );
	// NOTE: never try to include applet ref in print as it breaks in Safari 3

	if( typeof appletEl.getClass === 'undefined' ) {
		/* 
		NOTE: For some reason, when classic search applet is loaded in popup, applet element is found but its methods are not accessible.
		This works if we access with some delay.
		However, in IE with Java 1.4 search applet works although doesn't look accessible here
		so we let it procede anyway after some time.
		*/
		questagent.util.log.info("Can't access applet methods.");
		if(qaStartupDelay < 5) { 
			questagent.util.log.info("Can't access applet methods. Will lookup again in a sec...");
			qaStartupDelay++;
			setTimeout( OnAppletStart, 500 );
			return;
		}
		else {
			questagent.util.log.warn("Initialized with invalid applet reference");
		}
	}

	appletStarted = true;
	
	//questagent.util.log.debug("Applet class: " + appletEl.getClass() );
	if( typeof appletEl.getCollectionCount != 'undefined')
		questagent.util.log.debug("Collection count: " + appletEl.getCollectionCount() );

	// notify...
	var wrapper = questagent.util.getSearchAppletWrapper();
	questagent.util.log.debug("wrapper = " + wrapper);
	if( wrapper )
		wrapper.onAppletStarted( { applet : appletEl } );
	else
		questagent.util.log.fatal("Can't find applet wrapper");
	
	questagent.util.log.debug("completed OnAppletStart()");
	
}catch(e) { alert(e.message); }
}

function OnSearchCompleted(hitCount)
{
	questagent.util.log.debug("OnSearchCompleted()");
	
	var wrapper = questagent.util.getSearchAppletWrapper();
	if( wrapper )
		wrapper.onSearchCompleted(hitCount);
	else
		questagent.util.log.fatal("Can't find applet wrapper");
}

function OnHighlightingDone( hlPage )
{
	questagent.util.log.debug("OnHighlightingDone()");
	
	var model = questagent.util.getSearchInterfaceModel();
	if( model )
		model.handleHighlightedDocument(hlPage);
}

function OnShowResourceHandler( loc, hitIndex, newWin )
{
	questagent.util.log.debug("OnShowResourceHandler(): " + hitIndex + ', ' + loc);
	
	var model = questagent.util.getSearchInterfaceModel();
	if( model ) {
		model.showDocument(hitIndex, model.config.baseURL + loc);
	}
}
