//*****************************************************************
// qautil.js
//*****************************************************************

if (typeof questagent == "undefined") {
    var questagent = {};
}


if (typeof questagent.util == "undefined")
{
questagent.util = {};
(function() {

	qautil = questagent.util;

	qaconst = {};
	qaconst.qaScriptsFolder = 'qagent8/';

	// determine and save URL of current folder
	var homePath = window.location.href;
	var hind = homePath.lastIndexOf('/');
	qautil.userHomePath = homePath.substring(0,hind+1);


	/*
	 Returns reference to window containing QuestAgent search scripts.
	*/
	var getQuestAgent = function()
	{
		log.info('Lookup for questagent instance from window "' + window.name + '" (' + window.location + ')');
		// Note: questagent namespace exists in current window but it's valid only if initialized so we're checking id field
		if( window.questagent && window.questagent.id ) {
			log.debug("Found questagent instance: " + window.questagent.id);
			return window.questagent;
		}
		if( parent && parent.questagent && parent.questagent.id ) {
			log.debug("Found questagent instance in parent window: " + parent.questagent.id );
			return parent.questagent;
		}
		log.error("Not found questagent instance.");
		return null;
	}
	qautil.getQuestAgent = getQuestAgent;

	/*
	 Returns reference to window containing QuestAgent search scripts.
	*/
	var getSearchInterfaceModel = function()
	{
		if( window.qagentModel ) {
			log.debug("Found model in current window: " + window.name);
			return window.qagentModel;
		}

		if( parent ) {
			if( parent.qagentModel ) {
				log.debug("Found model instance in parent window: " + window.name);
				return parent.qagentModel;
			}
			var modelInFrame = findModelInFrame(parent);
			if( modelInFrame )
				return modelInFrame;
            else if(parent.parent) {
                modelInFrame = findModelInFrame(parent.parent);
                if( modelInFrame )
                    return modelInFrame;
            }
		}

		var params = qautil.getWindowParams();
		var qaid = params['ref'];
		if( qaid ) {
			log.debug('Looking up for questagent instance ' + qaid + ' via reference window.');
			// call with qaid expected only for quest's html's
			var win = window.open('empty.htm', qaid + '_ref');
			if( !win )
				throw "Can't open window?";
			log.debug('Obtained reference to ' + win.location + ' in frame named ' + win.name);

			if( win.parent ) {
				if( win.parent.qagentModel ) {
					log.debug('Found model by reference window.');
					return win.parent.qagentModel;
				}
				var modelInFrame = findModelInFrame(win.parent);
				if( modelInFrame )
					return modelInFrame;
			}
			log.warn('Reference window ' + win.parent + ' does not have parent or model? Trying to close just opened window.' );
			win.close(); // closing new window that we just created
		}

		log.error("Not found model instance.");
		return null;
	}
	qautil.getSearchInterfaceModel = getSearchInterfaceModel;

	/**
	Tries to find qagentModel in frames of specified window.
	*/
	var findModelInFrame = function( win )
	{
		if( !win.frames || !win.frames.length )
			return null;
		for( var i = 0; i < win.frames.length; i++ ) {

			log.debug('Lookup for model in frame "' + win.frames[i].name + '".');

			if( win.frames[i] && win.frames[i].qagentModel ) {
				log.debug('Found model in frame "' + win.frames[i].name + '".');
				return win.frames[i].qagentModel;
			}
		}
		return null;
	}

	/**
	Returns instance of questagent.SearchApplet for named or current window.
	*/
	var getSearchAppletWrapper = function(name)
	{
		var model = getSearchInterfaceModel();
		if( model && model.appletWrapper ) {
			log.debug("Found applet wrapper " + model.appletWrapper);
			return model.appletWrapper;
		}
		return null;
	}
	qautil.getSearchAppletWrapper = getSearchAppletWrapper;

	/**
	Returns QuestAgent home folder (folders where scripts are located).
	TODO doc
	*/
	var getQAHome = function(config)
	{
		if( config.qaHomeURL )
			return config.qaHomeURL; // return URL if available

		if( config.qaHomePath )
			return config.qaHomePath; // retyurn relative path if available


		log.debug("Looking up for reference of QuestAgent JavaScript inclusion");

		var base = findSrcPathForExtScript('questagent.js');
		log.debug("Found base of questagent.js: " + base);

		log.info("Auto-determined QuestAgent base is '" + base + "'");
		config.qaHomePath = base;
		return base;
	}
	qautil.getQAHome = getQAHome;

	/**
	Returns folder URL of file that loaded this script.
	*/
	var getUserHome = function()
	{
		return qautil.userHomePath;
	}
	qautil.getUserHome = getUserHome;

	/**
	Internal helper function that extracts relative path to folder containing specified script filename.
	The function will lookup for the path going through scrip inclusions in the current document.
	*/
	var findSrcPathForExtScript = function(filename)
	{
		var scripts = document.getElementsByTagName("script"); // @feature
		if(scripts) {
			for (var i = 0; i < scripts.length; i++) {
				var src = "" + scripts[i].getAttribute("src");
				var ind = src.indexOf(filename);
				if( ind != -1 ) {
					if( log )
						log.debug("Found reference to script " + src);
					return src.substring(0,ind);
				}
			}
			log.error("Not found reference to script: " + filename );
		}
		else {
			log.error("Did not find script references in page " + window.location );
		}
		return "";
	}


	/**
	Finds URL to QAHome (scripts folder) tracking down reference frame.
	Scripts URL is needed as IE and FF in a different way resolve relative paths from dynamically created documents
	@param frameRef Window name or reference to window object.
	*/
	var findQAHomeURL = function(frameRef)
	{
		var frame = (typeof frameRef == 'string') ? frames[frameRef] : frameRef;

		if( frame && frame.location)
		{
			var path = frame.location.href;
			log.debug("Reference frame location: '" + path + "'");
			var ind = path.lastIndexOf('/');
			if( ind == -1 )
				throw ("Expected at least one slash in " + path); // may happen if iframe not loaded yet (about:)
			path = path.substring(0,ind+1);

			log.info("Determined scripts base is '" + path + "'");
			return path;
		}
		else
		{
			log.error("Can't find frame " + frameRef);
			return '';
		}
	}
	qautil.findQAHomeURL = findQAHomeURL;

	/**
	...
	*/
	var findLargestFrameDeep = function(win)
	{
		var f = findLargestFrame(win);
		var m = f;
		while (f && f.frame && f.frame.frames && f.frame.frames.length > 0) {
			log.debug("Checking deeply frame: " + f.name);
			f = findLargestFrame(f.frame);
			if( f.p > m.p )
				m = f;
		}
		return m;
	}
	qautil.findLargestFrameDeep = findLargestFrameDeep;

	/**
	Returns object containing name and reference to the largest frame in specified window/frame.
	*/
	var findLargestFrame = function(win)
	{
		if( !win || !win.frames )
		{
			log.debug("No frames in " + win.name);
			return null;
		}

		var result = {name:'', p:0, width:0, height:0, frame:null};
		for( var i = 0; i < win.frames.length; i++ )
		{
			var frame = win.frames[i];
			//log.debug("Investigating size of frame: " + frame.name);

			var size = getWindowSize(frame);
			var p = size.width * size.height;

/*            if(frame.frames && frame.frames.length > 0) {
                log.debug("Check nested frameset of frame " + frame.name);
                var df = findLargestFrame(frame);
                p = df.p;
                frame = df.frame;
                size = df;
            }*/

            log.debug("Size of frame: " + frame.name + ": " + size.width + " x " +  size.height + " = " + p);

			if( p > result.p )
			{
				result.name = frame.name;
				result.p = p;
				result.width = size.width;
				result.height = size.height;
				result.frame = frame;
			}
		}
		log.debug("The largest frame is: " + result.name);
		return result;
	}
	qautil.findLargestFrame = findLargestFrame;


	/**
	Returns object with 'width' and 'height' of a specified window/frame.
	*/
	var getWindowSize = function(win)
	{
		if( !win )
			win = window;

		var res = new Object();
		res.width = 0; res.height = 0;

		if( win.innerWidth ) {
			//Non-IE
			log.debug("Found window.innerWidth/Height");
			res.width = win.innerWidth;
			res.height = win.innerHeight;
		}
		else if( win.document.documentElement && ( win.document.documentElement.clientWidth || win.document.documentElement.clientHeight ) ) {
			//IE 6+ in 'standards compliant mode'
			res.width = win.document.documentElement.clientWidth;
			res.height = win.document.documentElement.clientHeight;
		} else if( win.document.body && ( win.document.body.clientWidth || win.document.body.clientHeight ) ) {
			//IE 4 compatible
			res.width = win.document.body.clientWidth;
			res.height = win.document.body.clientHeight;
		}
		return res;
	}
	qautil.getWindowSize = getWindowSize;


	/**
		@param Y instance of YAHOO. If not specified will use one from the current window.
	*/
	var showPleaseWaitPanel = function( message, target, config )
	{
		log.debug('Need to show wait message ' + message + '" in window ' +
			(target ? (target.name) : '[no name]') );

		var showwait = function()
		{
			Y = target.YAHOO;

			if( !Y || !Y.widget || !Y.widget.Panel ) {
				log.debug('Can not show init panel without YUI reference and container widgets.');
				return;
			}

			Y.namespace('jobjects.questagent');
			var doc = target.document;

			var wait =  new Y.widget.Panel("qaWait",
				{ width:"300px",
				  fixedcenter:true,
				  close:false,
				  draggable:false,
				  modal:true,
				  visible:false
				}
			);

			if( config.msgPleaseWaitTitle )
				wait.setHeader(config.msgPleaseWaitTitle);
			wait.setBody('<div style="text-align: center;"><div style="margin:auto">' +
				'<img src="' + getQAHome(config) + config.imgWaitBig + '" align="ABSMIDDLE">&nbsp;&nbsp;' +
				message + '</div></div>' );
			wait.render(doc.body);

			// use YUI skin "sam"
			if( !Y.util.Dom.hasClass(wait.element, 'yui-skin-sam') )
				Y.util.Dom.addClass(wait.element, 'yui-skin-sam');

			Y.jobjects.questagent.waitPanel = wait;
			Y.jobjects.questagent.waitPanel.show();
		};

		try {
			target = target || window;
			config = config || target.qaAltInit || target.qagentConfig;
			var Y = target.YAHOO;
			if( !Y || !Y.widget || !Y.widget.Panel ) {
				log.info('Can not show wait panel without YUI reference. Injecting needed scripts.');
				qautil.addYUI( target, config, function() {
					showwait(); } );
			}
			else
				showwait();
		}
		catch( e ) {
			// wait panel is jut an add-on so any error in this part should not stop further execution
			log.info( e );
		}
	}
	qautil.showPleaseWaitPanel = showPleaseWaitPanel;

	var hidePleaseWaitPanel = function( target )
	{
		try {
			if( target && target.YAHOO.jobjects.questagent.waitPanel )
				target.YAHOO.jobjects.questagent.waitPanel.hide();
		}
		catch( e ) {
			// wait panel is jut an add-on so any error in this part should not stop further execution
			log.info( e );
		}
	}
	qautil.hidePleaseWaitPanel = hidePleaseWaitPanel;

	var showEngineInitOverlay = function( target, config )
	{
		log.debug( "showEngineInitOverlay()" );

		target = target || window;
		config = config || target.qaAltInit || target.qagentConfig;
		var Y = target.YAHOO;
		if( !Y || !Y.widget || !Y.widget.Overlay ) {
			log.debug('Can not show init panel without YUI reference and container widgets.');
			return;
		}
		var doc = target.document;

		var initializingMessage;

		var formDiv = target.document.getElementById(config.searchFormId);
		if( formDiv ) {
			// if form was found, show loading icon and messsage on a top of the form
			//log.debug( "Found user provided search form." );

			var formReg = Y.util.Dom.getRegion( formDiv );
			// find last element in form
			var lastEl = Y.util.Dom.getRegion( Y.util.Dom.getLastChildBy( formDiv,
				function( e ) {
					log.debug( 'Testing node: ' + e );
					if( Y.util.Dom.getRegion( e ) )
						return true;
					return false;
				} ) ) || formReg;

			w = (lastEl.right - formReg.left) + "px";
			h = (lastEl.bottom - formReg.top) + "px";

			log.debug( 'Form region ' + formReg);
			log.debug( 'Last form element ' + lastEl);

			initializingMessage = new Y.widget.Overlay("qaInitializingMessage",
				{
					xy:[formReg.left,formReg.top],
					appendtodocumentbody : true, // TODO: can we use zIndex as described in YUI 2.3.1 release notes?
					width: w, height: h,
					visible:false
				} );

			var body = '<div style="text-align: center;"><div style="margin:auto">' +
				'<img src="' + getQAHome(config) + 'loader-indicator-small.gif" ' +
				' title="' + config.msgInitializingQA + '" alt="please wait"' +
				' border="0" align="ABSMIDDLE"/>&nbsp;' +
				config.msgInitializingQA + '</div></div>';

			initializingMessage.setBody( body );
			initializingMessage.render(doc.body);

			Y.util.Dom.setStyle(initializingMessage.body, 'border', '1px solid #aeaeae');
			Y.util.Dom.setStyle(initializingMessage.body, 'background-color', '#FFF'); // TODO parametrize color?
		}
		else { // if search form was not found, show loading icon in the right top corner of document
			initializingMessage = new Y.widget.Overlay("qaInitializingMessage",
				{
					width:"32px",
					context:[doc.body,"tr","tr"],
					appendtodocumentbody : true, // TODO: can we use zIndex as described in YUI 2.3.1 release notes?
					visible:false
				} );

			var body = '<img src="' + getQAHome(config) + 'loader-indicator-big.gif" ' +
				' title="' + config.msgInitializingQA + '" ' +
				' border="0" />';
			initializingMessage.setBody( body );
			initializingMessage.render(doc.body);
		}

		if( initializingMessage ) {
			initializingMessage.show();
			Y.jobjects.questagent.initializingMessage = initializingMessage;
		}
	}
	qautil.showEngineInitOverlay = showEngineInitOverlay;

	/**

		@param {function} callbackfn - function that receives notification about completed YUI loading. Parameter 'false' means that YUI was already present in target; 'true' that it was added to it.
	*/
	function addYUI( target, config, callbackfn )
	{
		if( target.YAHOO ) {
			log.debug('Window already has YUI: ' + target.name + ' ' + target.location);
			if( callbackfn )
				callbackfn( false );
			return;
		}
		log.debug('Injecting YUI to window: ' + target.name + ' ' + target.location);

		if( !target.questagent )
			target.questagent = {};
		if( !target.questagent.util )
			target.questagent.util = qautil;

		// import YUI skin
		injectStyle(
			getQAHome( config ) + 'jsutil/yui2/container/assets/skins/sam/container.css',
			target.document);

		injectScript(
			getQAHome( config ) + 'jsutil/yui2/yuiloader-dom-event/yuiloader-dom-event.js',
			null,null,target.document);
			
		window.yahooInjectLoaderFn = function() {
			if(target.YAHOO && target.YAHOO.util && target.YAHOO.util.YUILoader) {
				var loader = new target.YAHOO.util.YUILoader( {
					require: ['container'],
					base: (getQAHome( config ) + 'jsutil/yui2/'),
					loadOptional: false,

					onSuccess: function(loader) {
						if( callbackfn )
							callbackfn( true );
					}
				} );
				loader.insert();
			}
			else {
				setTimeout("window.yahooInjectLoaderFn()", 50);
			}
		}
		setTimeout("window.yahooInjectLoaderFn()", 50);	
	}
	qautil.addYUI = addYUI;

	function injectScript(src, id, code, doc, el)
	{
		if( !doc )
			doc = document;

		var script = doc.createElement('script');
		script.type = 'text/javascript';

		if( src )
			script.src = src;

		if( id )
			script.id = id;

		if( code ) {
			// IE doesn't let script elements have children.
			if (null != script.canHaveChildren) script.text = code;
			// But most other browsers do.
			else script.appendChild(doc.createTextNode(code));
		}

		el = el || doc.getElementsByTagName('head')[0];

		if( window.questagent && window.questagent.util && window.questagent.util.log )
			window.questagent.util.log.debug( 'Importing script: ' + script.src );

		el.appendChild(script);
	}
	qautil.injectScript = injectScript;

	function injectStyle(src, doc)
	{
		// FIXME make sure that style is not already defined?  or is it handled by test of YAHOO presence on form injection

		var headID = doc.getElementsByTagName("head")[0];
		var cssNode = doc.createElement('link');
		cssNode.type = 'text/css';
		cssNode.rel = 'stylesheet';
		cssNode.href = src;
		cssNode.media = 'screen';

		if( window.questagent && window.questagent.util && window.questagent.util.log )
			window.questagent.util.log.debug( 'Importing style: ' + cssNode.href );

		headID.appendChild(cssNode);
	}
	qautil.injectStyle = injectStyle;


	var removeAllOptions = function(selectbox)
	{
		if( selectbox && selectbox.options && selectbox.options.length ) {
			for(var i=selectbox.options.length-1;i>=0;i--) {
				selectbox.remove(i);
			}
		}
		else {
			log.error('Received argument is not select box: ' + selectbox);
		}
	}
	qautil.removeAllOptions = removeAllOptions;

	var addOption = function( selectbox,text,value )
	{
		/* // options.add() doesn't work in Safari
		var optn = document.createElement("OPTION");
		optn.text = text;
		optn.value = value;
		selectbox.options.add(optn);
		*/
		selectbox.options[selectbox.options.length] = new Option(text,value);
	}
	qautil.addOption = addOption;

	var populateCollectionList = function( collectionSelect, applet, msgAllCollections )
	{
		if( typeof collectionSelect != "string" ) {
			log.debug('Populating collection list to select box');
			try {
				qautil.removeAllOptions( collectionSelect );

				// if there's more than one collection defined, first option is for "search all"
				if( applet.getCollectionCount() > 1 && msgAllCollections )
					qautil.addOption( collectionSelect, msgAllCollections, '[all]' );

				for( var i = 0; i < applet.getCollectionCount(); i++ ) {
					var id = applet.getCollectionId(i);
					var name = applet.getCollectionName(i);
					log.debug('Added collection ' + i + ': ' + id + ' = ' + name);
					qautil.addOption( collectionSelect, name, id );
				}
			}
			catch(e) {
				// if population of list fails for any reason (browser DOM compliance?),
				// at least search in all collections should be possible
				log.error("Failed to populate list of collections.");
				log.error(e);
			}
		}
	}
	qautil.populateCollectionList = populateCollectionList;


	var popupWindow = function( url, winName, winWidth, winHeight, options )
	{
		log.debug( 'Popup ' + url + ' with options ' + options );

		windowOptions = 'width=' + winWidth + ',height=' + winHeight +
			',scrollbars=yes,toolbar=no,directories=no,status=no,menubar=no,location=no,dependent=yes';

		if(options)
			windowOptions += ',' + options;

		var f = window.open(url, winName, windowOptions);
		return f;
	}
	qautil.popupWindow = popupWindow;


	var insertQAJavaApplet = function( config, doc )
	{
		doc.writeln(getQAJavaAppletHTML(config));
	}
	qautil.insertQAJavaApplet = insertQAJavaApplet;


	var getQAJavaAppletHTML = function( config )
	{
		var app = new Object();
		app.code = 'com.jobjects.quest.agent.LiveConnectApplet';
		app.codebase = '..';
		app.archive = 'qagent.jar';
		app.id = 'QuestAgent';
		app.width = '1';
		app.height = '1';
		app.mayscript = true;
		app.alt = 'JObjects QuestAgent search applet (http://www.jobjects.com)';

		app.params = new Object();
		app.params['DefaultsFile'] = qaconst.qaScriptsFolder + 'defaults.prm';
		app.params['ParamFile'] = config.paramFile || qaconst.qaScriptsFolder + 'qagent.prm';
		app.params['js.OnAppletStart'] = 'OnAppletStart';
		app.params['js.OnSearchResults'] = 'OnSearchCompleted';
		app.params['KeywordsInContext'] = 'yes';
		app.params['maxSearchTime'] = '20000';
		//app.params['js.OnNoLCPage'] = 'qagent8/qa_welcome.htm'; // TODO ?
		//app.params['js.OnNoLCFrame'] = 'qa_msg'; // TODO ?

		return getAppletHTML(app);
	}
	//qautil.getQAJavaAppletHTML = getQAJavaAppletHTML; // hidden to force use of 'insertQAJavaApplet()' due to Eolas


	var getQAVisualAppletHTML = function( width, height, config )
	{
		var app = new Object();
		app.code = 'com.jobjects.quest.agent.SearchApplet';
		app.codebase = '..';
		app.archive = 'qagent.jar';
		app.id = 'QuestAgent';
		app.width = width;
		app.height = height;
		app.mayscript = true;
		app.alt = 'JObjects QuestAgent search applet (http://www.jobjects.com)';

		app.params = new Object();
		app.params['DefaultsFile'] = qaconst.qaScriptsFolder + 'defaults.prm';
		app.params['ParamFile'] = config.paramFile || qaconst.qaScriptsFolder + 'qagent.prm';
		app.params['js.OnAppletStart'] = 'OnAppletStart';
		//app.params['js.OnNoLCPage'] = 'qagent8/qa_welcome.htm'; // TODO ?
		//app.params['js.OnNoLCFrame'] = 'qa_msg'; // TODO ?

		if( config.highlightingEnabled ) {
			app.params['js.OnShowResource'] = 'OnShowResourceHandler';
		}
		else {
			// if highlight is disabled, let applet open document it self
			log.info('Document target for applet: ' + config.documentTargetFrameName);
			app.params['target'] = config.documentTargetFrameName;
		}

		if( config.params && config.params.query )
			app.params['query'] = config.params.query;

		if( config.componentList )
			app.params['componentList'] = config.componentList;

		return getAppletHTML(app);
	}
	qautil.getQAVisualAppletHTML = getQAVisualAppletHTML;

	/**
	Creates applet initialization HTML based on used browser.
	*/
	var getAppletHTML = function( app )
	{
		log.info('Applet config:');
		log.info(app);
		log.info('... with params:');
		log.info(app.params);

		var html = [];

		if( UA.bIsIE && !UA.bIsISMac )
		{
			log.info('Creating applet inclusion HTML for IE using OBJECT tag');

			html.push('<OBJECT classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"');
			html.push('  width="' + app.width + '" height="' + app.height + '" align="baseline"');
			html.push('  name="' + app.id + '" id="' + app.id + '"');
			html.push('  codebase="http://java.sun.com/products/plugin/autodl/jinstall-1_4-windows-i586.cab#Version=1,4,2,0" >');
			//html.push('  codebase="http://java.sun.com/update/1.6.0/jinstall-6-windows-i586.cab#Version=1,6,0,0" >');
//			html.push('<PARAM name="type" value="application/x-java-applet;jpi-version=1.4.2" />');
			html.push('<PARAM name="type" value="application/x-java-applet" />');
			html.push('<PARAM name="code" value="' + app.code + '.class" />');
			html.push('<PARAM name="codebase" value="' + app.codebase + '" />');
			html.push('<PARAM name="archive" value="' + app.archive + '" />');
			if( app.mayscript ) {
				html.push('<PARAM name="scriptable" value="true" />');
				html.push('<PARAM name="mayscript" value="true" />');
			}
			for(var p in app.params)
			{
				var val = app.params[p];
				var v = val.replace(/\\"/g, "&quot;");
				v = v.replace(/"/g, "&quot;");
				html.push('<PARAM name="' + p + '" value="' + v + '" />');

			}
			//html.push('No Java 2 SDK, Standard Edition v 1.4.2 or higher is required for QuestAgent search applet!');
			html.push('</OBJECT>');

		}
		else if( UA.bIsGecko )
		{
			log.info('Creating applet inclusion HTML for Gecko using EMBED tag');

			html.push('<embed ');
			html.push('  code="' + app.code + '"');
			html.push('  type="application/x-java-applet;version=1.4"');
			html.push('  width="' + app.width + '" height="' + app.height + '" align="baseline"');
			html.push('  name="' + app.id + '" id="' + app.id + '"');
			html.push('  codebase="' + app.codebase + '"');
			html.push('  archive="' + app.archive + '"');
			if( app.mayscript ) {
				html.push('  mayscript="true"');
			}
			for(var p in app.params)
			{
				var val = app.params[p];
				var v = val.replace(/\\"/g, "&quot;");
				v = v.replace(/"/g, "&quot;");
				html.push('  ' + p + '="' + v + '"');

			}
			html.push('>');
			html.push('<noembed>');
			html.push('No Java 2 SDK, Standard Edition v 1.4.2 or higher is required for QuestAgent search applet!');
			html.push('</noembed>');
			html.push('</embed>');
		}
		else
		{
			log.info('Creating applet inclusion HTML relying on deprecated APPLET tag');

			html.push('<applet code="' + app.code + '" ');
			html.push('  codebase="' + app.codebase + '"');
			html.push('  archive="' + app.archive + '"');
			html.push('  name="' + app.id + '" id="' + app.id + '"');
			html.push('  width="' + app.width + '" height="' + app.height + '"');
			html.push('  mayscript="' + app.mayscript + '"');
			html.push('  alt="' + app.alt + '"');
			html.push('>');
			for(var p in app.params)
			{
				var val = app.params[p];
				var v = val.replace(/\\"/g, "&quot;");
				v = v.replace(/"/g, "&quot;");
				html.push('<param name="' + p + '" value="' + v + '" />');
			}
			html.push('</applet>');
		}

		var appletHtml = html.join('');
		log.debug('Created applet init HTML: ' + appletHtml);

		return appletHtml;
	}
	qautil.getAppletHTML = getAppletHTML;


	var copyObject = function( obj )
	{
		var res = {};
		for(var p in obj) {
			res[p] = obj[p];
		}
		return res;
	}
	qautil.copyObject = copyObject;


	/**
	Returns true if form with query field and button are found in specified window.
	*/
	var isSearchFormPresent = function( targetWindow, config )
	{
		log.debug('Lookup for search form in window ' + targetWindow.name);

		var form = targetWindow.document.getElementById(config.searchFormId);
		log.debug("form : " + form + ' is ' + (typeof form) );

		if( !form ) {
			log.debug('Form was not found: ' + form);
			return false;
		}

		return true;
	}
	qautil.isSearchFormPresent = isSearchFormPresent;


	var attachSearchFormHandlers = function( targetWindow, config )
	{
		log.debug('Attaching handlers to search form in window: ' + (targetWindow ? targetWindow.name : targetWindow) );

		// attach to search form...
		var form = targetWindow.document.getElementById(config.searchFormId);
		log.debug("form : " + form );

		if( form )
		{
			log.debug('Found form "' + config.searchFormId + '". Trying to attach event handlers.');

			// delete action attribute - in case form is taken wrom web site
			form.removeAttribute("action");

			// required in FF but not sufficient in IE
			//form.setAttribute("onsubmit", "startSearch(); return false;"); // FIXME function name is deployment dependent
			//form.removeAttribute("onsubmit");

			// Firefox will submit form if at least one handler does not return false
			// so it's not sufficient to delete attribute only
			form.setAttribute("onsubmit", "return false;");

			log.debug("Form onsubmit : " + form.getAttribute("onsubmit") );

			// The following is needed for IE but doesn't work in FF
			// In FF 2.0 the following handler triggers search but doesn't stop form from being submitted.
			// That's why we specified onsubmit handler directly in form element
			YAHOO.util.Event.addListener(form, 'submit', function() {
				startSearch();
				return false;
			}, window, true );
			log.debug("Attached 'submit' listener to search form." );

			log.debug("onsubmit after observe: " + form.getAttribute("onsubmit") );

			if( config.searchButtonId ) {
				var button = targetWindow.document.getElementById(config.searchButtonId);
				log.debug('button:'+button);
				if(button) {
					button.removeAttribute('onclick');
					//button.setAttribute('onclick', 'startSearch();');

					YAHOO.util.Event.addListener(button, 'click', function() {
						startSearch();
					}, window, true );
					log.debug("Attached 'click' listener to search form." );

					log.debug("Button onclick: " + button.getAttribute("onclick") );
				}
			}

			log.debug("For action : " + form.getAttribute("action") );

			return form;
		}
		else
		{
			log.warn('Form "' + config.searchFormId + '" was not found. ' +
				'Developer should handle form events.');
			return null;
		}
	}
	qautil.attachSearchFormHandlers = attachSearchFormHandlers;

	var getWindowParams = function()
	{
		var s = window.location.search;
		return extractParams( s );
	}
	qautil.getWindowParams = getWindowParams;

	/*
	 Returns object containing parameters found in the specified string.
	 */
	function extractParams( p )
	{
		if( p.charAt( 0 ) == '?' )  {
			p = p.substring( 1, p.length );
		}

		var paramsObject = new Object();

		var params = p.split( '&' );
		for( i = 0; i < params.length; i++ )
		{
			var ind = params[i].indexOf( "=" );
			if( ind != -1 )
			{
				var name = params[i].substring( 0, ind );
				var val = unescape( params[i].substring( ind + 1 ) );

				if( val == "true" || val == "false" || !isNaN( parseFloat( val ) ) ) {
					paramsObject[name] = eval(val);
				}
				else {
					paramsObject[name] = val;
				}
				if( log )
					log.info('Window param: ' + name + ' = ' + val); // not available during init
			}
		}
		return paramsObject;
	}

	var formSetEnabled = function( form, enabled )
	{
		if( !form )
			return;
		var disabled = !enabled;
		var elements = form.getElementsByTagName('*');
		for( var i = 0; i < elements.length; i++ ) {
			var el = elements[i];
			// TODO could check el.tagName to make sure we access form elements
			if( el.disabled != null )
				el.disabled = disabled;
		}
	}
	qautil.formSetEnabled = formSetEnabled;


	// Setting and getting cookies...

	var isCookieEnabled = function()
	{
	  setCookie( "testCookie", "OK", 1 );
	  testing = getCookie( "testCookie" );
	  return ( testing == "OK" );
	}
	qautil.isCookieEnabled = isCookieEnabled;

	var getAllCookies = function()
	{
	  var cookies  = document.cookie.replace(/ /g,"").split(";");
	  for (var i = 0; i < cookies.length; i++){
	    cookiePair = cookies[i].split("=");
	    document.write("["+cookiePair[0]+"] = ["+ unescape(cookiePair[1])+"]<br><br>");
	  }
	}
	qautil.getAllCookies = getAllCookies;

	var getCookie = function( name ) {
		var start = document.cookie.indexOf( name + "=" );
		var len = start + name.length + 1;
		if ( ( !start ) && ( name != document.cookie.substring( 0, name.length ) ) ) {
			return null;
		}
		if ( start == -1 ) return null;
		var end = document.cookie.indexOf( ";", len );
		if ( end == -1 ) end = document.cookie.length;
		return unescape( document.cookie.substring( len, end ) );
	}
	qautil.getCookie = getCookie;

	var setCookie = function( name, value, expires, path, domain, secure )
	{
		var today = new Date();
		today.setTime( today.getTime() );
		if ( expires ) {
			expires = expires * 1000 * 60 * 60 * 24;
		}
		var expires_date = new Date( today.getTime() + (expires) );
		document.cookie = name+"="+escape( value ) +
			( ( expires ) ? ";expires="+expires_date.toGMTString() : "" ) + //expires.toGMTString()
			( ( path ) ? ";path=" + path : "" ) +
			( ( domain ) ? ";domain=" + domain : "" ) +
			( ( secure ) ? ";secure" : "" );
	}
	qautil.setCookie = setCookie;

	var deleteCookie = function( name, path, domain )
	{
		if ( getCookie( name ) ) document.cookie = name + "=" +
				( ( path ) ? ";path=" + path : "") +
				( ( domain ) ? ";domain=" + domain : "" ) +
				";expires=Thu, 01-Jan-1970 00:00:01 GMT";
	}
	qautil.deleteCookie = deleteCookie;


	// QA config related...

	var isScriptDebugEnabled = function()
	{
	  try{
		var win = window;
		while( true ) {
			if( win.location.search ) {
				var winParams = extractParams(win.location.search);
				if( winParams['debug'] ) {
					if( winParams['debug'] == 'false' )
						return false;
					else
						return true;
				}
			}
			if( win.parent == win )
				break;
			win = win.parent;
		}
		return ( "DEBUG" == getCookie( "QAJSLog" ) );
	  } catch(e) {
		return false;
	  }
	}
	qautil.isScriptDebugEnabled = isScriptDebugEnabled;

	var setScriptDebugEnabled = function( state )
	{
		if( state )
			setCookie( "QAJSLog", "DEBUG", 365, "/" );
		else
			deleteCookie( "QAJSLog", "/" );
	}
	qautil.setScriptDebugEnabled = setScriptDebugEnabled;


	var extendClass = function(subClass, baseClass) {
		function inheritance() {}
		inheritance.prototype = baseClass.prototype;

		subClass.prototype = new inheritance();
		subClass.prototype.constructor = subClass;
		subClass.baseConstructor = baseClass;
		subClass.superClass = baseClass.prototype;
	}
	qautil.extendClass = extendClass;


	// ======================== User Agent code starts ===================

	/**
	UserAgent  detection (taken from sIFR 2.0.2)
	*/
	var UA = function(){
		var sUA = navigator.userAgent.toLowerCase();
		var oReturn =  {
			bIsWebKit : sUA.indexOf("applewebkit") > -1,
			bIsSafari : sUA.indexOf("safari") > -1,
			bIsKonq: navigator.product != null && navigator.product.toLowerCase().indexOf("konqueror") > -1,
			bIsOpera : sUA.indexOf("opera") > -1,
			bIsXML : document.contentType != null && document.contentType.indexOf("xml") > -1,
			bHasTransparencySupport : true,
			bUseDOM : true,
			nFlashVersion : null,
			nOperaVersion : null,
			nGeckoBuildDate : null,
			nWebKitVersion : null
		};

		oReturn.bIsKHTML = oReturn.bIsWebKit || oReturn.bIsKonq;
		oReturn.bIsGecko = !oReturn.bIsWebKit && navigator.product != null && navigator.product.toLowerCase() == "gecko";
		if(oReturn.bIsGecko && sUA.match(/.*gecko\/(\d{8}).*/)){ oReturn.nGeckoBuildDate = new Number(sUA.match(/.*gecko\/(\d{8}).*/)[1]) };
    if(oReturn.bIsOpera && sUA.match(/.*opera(\s|\/)(\d+\.\d+)/)){ oReturn.nOperaVersion = new Number(sUA.match(/.*opera(\s|\/)(\d+\.\d+)/)[2]) };
		oReturn.bIsIE = sUA.indexOf("msie") > -1 && !oReturn.bIsOpera && !oReturn.bIsKHTML && !oReturn.bIsGecko;
		oReturn.bIsIEMac = oReturn.bIsIE && sUA.match(/.*mac.*/) != null;
		if(oReturn.bIsIE || (oReturn.bIsOpera && oReturn.nOperaVersion < 7.6)){ oReturn.bUseDOM = false };
		if(oReturn.bIsWebKit && sUA.match(/.*applewebkit\/(\d+).*/)){ oReturn.nWebKitVersion = new Number(sUA.match(/.*applewebkit\/(\d+).*/)[1]) };
		if(window.hasFlash && (!oReturn.bIsIE || oReturn.bIsIEMac)){
			var flashDescription = (navigator.plugins["Shockwave Flash 2.0"] || navigator.plugins["Shockwave Flash"]).description;
			oReturn.nFlashVersion = parseInt(flashDescription.charAt(flashDescription.indexOf(".") - 1));
		};
		if(sUA.match(/.*(windows|mac).*/) == null ||
		oReturn.bIsIEMac || oReturn.bIsKonq ||
		(oReturn.bIsOpera && oReturn.nOperaVersion < 7.6) ||
		(oReturn.bIsSafari && oReturn.nFlashVersion < 7) ||
		(!oReturn.bIsSafari && oReturn.bIsWebKit && oReturn.nWebKitVersion < 312) ||
		(oReturn.bIsGecko && oReturn.nGeckoBuildDate < 20020523)){
			oReturn.bHasTransparencySupport = false;
		};

		if(!oReturn.bIsIEMac && !oReturn.bIsGecko && document.createElementNS){
			try {
				document.createElementNS(sNameSpaceURI, "i").innerHTML = "";
			} catch(e){
				oReturn.bIsXML = true;
			};
		};

		oReturn.bUseInnerHTMLHack = oReturn.bIsKonq || (oReturn.bIsWebKit && oReturn.nWebKitVersion < 312);

		return oReturn;
	}();
	qautil.UA = UA;

	function isdefined( variable)
	{
		return (typeof(window[variable]) == "undefined")?  false: true;
	}
	qautil.isdefined = isdefined;


	var log;

	function initQAUtilPackage()
	{
		// init local log
		if( isScriptDebugEnabled() ) {
			log = window.log4javascript.getDefaultLogger();
		}
		else {
			log = window.log4javascript.getNullLogger();
		}
		qautil.log = log;
	}
	// start initialization of questagent.util package
	initQAUtilPackage();


	qautil.bootstrap = {};

	function checkQuestAgent(name, loaderCallback) {
		if (window.questagent && window.questagent.initSearchApplet) {
			loaderCallback();
		}
		else {
			setTimeout(function() { checkQuestAgent(name, loaderCallback); }, 50);
		}
	}
	qautil.bootstrap.checkQuestAgent = checkQuestAgent;

	function checkCallbacks(name, loaderCallback) {
		if (window.OnShowResourceHandler && window.OnAppletStart) {
			loaderCallback();
		}
		else {
			setTimeout(function() { checkCallbacks(name, loaderCallback); }, 50);
		}
	}
	qautil.bootstrap.checkCallbacks = checkCallbacks;

})();
}

Array.prototype.push = function() {
	var n = this.length >>> 0;
	for (var i = 0; i < arguments.length; i++) {
	this[n] = arguments[i];
	n = n + 1 >>> 0;
	}
	this.length = n;
	return n;
};

Array.prototype.pop = function() {
	var n = this.length >>> 0, value;
	if (n) {
	value = this[--n];
	delete this[n];
	}
	this.length = n;
	return value;
};
